/*
 * QrfeMutexLocker.cpp
 *
 *  Created on: 15.02.2011
 *      Author: stefan.detter
 */

#include "../inc/QrfeMutexLocker.h"

uint QrfeMutexLocker::_traceLevel = 11;

QrfeMutexLocker::QrfeMutexLocker(QMutex* mutex)
	: QrfeTraceModule("QrfeMutexLocker", _traceLevel)
	, m_mutex(mutex)
	, m_name("")
{
	trc(0, "    -> Lock");
	mutex->lock();
	trc(0, "    -> Locked");
}

QrfeMutexLocker::QrfeMutexLocker(QMutex* mutex, QString name)
	: QrfeTraceModule("QrfeMutexLocker", _traceLevel)
	, m_mutex(mutex)
	, m_name(name)
{
	trc(0, "    -> Lock for " + m_name);
	mutex->lock();
	trc(0, "    -> Locked for " + m_name);
}

QrfeMutexLocker::~QrfeMutexLocker()
{
	trc(0, "    <- Unlock from " + m_name);
	m_mutex->unlock();
	trc(0, "    <- Unlocked from " + m_name);
}

QMutex*	QrfeMutexLocker::mutex () const
{
	return m_mutex;
}

void QrfeMutexLocker::relock ()
{
	m_mutex->lock();
}

void QrfeMutexLocker::unlock ()
{
	m_mutex->unlock();
}
